<?php

declare(strict_types=1);

use Rector\Config\RectorConfig;
use Rector\Set\ValueObject\SetList;
use Rector\PHPUnit\Set\PHPUnitSetList;
use Rector\Set\ValueObject\LevelSetList;
use Rector\PHPUnit\Set\PHPUnitLevelSetList;
use Rector\Php71\Rector\FuncCall\CountOnNullRector;
use Rector\Php80\Rector\FunctionLike\MixedTypeRector;
use Rector\Php80\Rector\FunctionLike\UnionTypesRector;
use Rector\Php80\Rector\NotIdentical\StrContainsRector;
use Rector\Php73\Rector\FuncCall\JsonThrowOnErrorRector;
use Rector\Php73\Rector\String_\SensitiveHereNowDocRector;
use Rector\Php71\Rector\FuncCall\RemoveExtraParametersRector;
use Rector\Php80\Rector\Catch_\RemoveUnusedVariableInCatchRector;
use Rector\Php71\Rector\ClassConst\PublicConstantVisibilityRector;
use Rector\Php74\Rector\LNumber\AddLiteralSeparatorToNumberRector;
use Rector\Php81\Rector\ClassConst\FinalizePublicClassConstantRector;
use Rector\Php81\Rector\FuncCall\NullToStrictStringFuncCallArgRector;
use Rector\TypeDeclaration\Rector\Property\TypedPropertyFromAssignsRector;
use Rector\CodeQuality\Rector\Class_\InlineConstructorDefaultToPropertyRector;
use Rector\Php80\Rector\Class_\ClassPropertyAssignToConstructorPromotionRector;

return static function (RectorConfig $rectorConfig): void {
    $rectorConfig->paths([
        __DIR__ . '/src',
        __DIR__ . '/tests',
    ]);

    // register a single rule
    // $rectorConfig->rule(InlineConstructorDefaultToPropertyRector::class);

    // $rectorConfig->rule(AssertPropertyExistsRector::class);
    
    // define sets of rules
    $rectorConfig->sets([
        //    LevelSetList::UP_TO_PHP_82,
        // LevelSetList::UP_TO_PHP_82,
           PHPUnitSetList::PHPUNIT_90 ,
        //    PHPUnitSetList::PHPUNIT_100,
    //  PHPUnitLevelSetList::UP_TO_PHPUNIT_90,
     SetList::PHP_82,
    ]);

    $rectorConfig->skip([
        SimplifyIfReturnBoolRector::class,
        JsonThrowOnErrorRector::class,
        TypedPropertyFromAssignsRector::class,
        RemoveExtraParametersRector::class,
        AddLiteralSeparatorToNumberRector::class,
        PublicConstantVisibilityRector::class,
        CountOnNullRector::class,
        SensitiveHereNowDocRector::class,
        ClassPropertyAssignToConstructorPromotionRector::class,
        UnionTypesRector::class,
        MixedTypeRector::class,
        StrContainsRector::class,
        NullToStrictStringFuncCallArgRector::class,
        RemoveUnusedVariableInCatchRector::class,
        FinalizePublicClassConstantRector::class,
        // GetMockBuilderGetMockToCreateMockRector::class,
            
            
    ]);
};
