<?php

namespace Cloudflare\API\Test\Endpoints;

use Cloudflare\API\Test\TestCase;
use Cloudflare\API\Adapter\Adapter;
use Cloudflare\API\Endpoints\Membership;

class MembershipTest extends TestCase
{
    public function testListMemberships()
    {
        $response = $this->getPsr7JsonResponseForFixture('Endpoints/listMemberships.json');

        $mock = $this->createMock(Adapter::class);
        $mock->method('get')->willReturn($response);

        $mock->expects($this->once())
            ->method('get')
            ->with(
                $this->equalTo('memberships'),
                $this->equalTo([
                    'page' => 1,
                    'per_page' => 20,
                    'account.name' => 'Demo Account',
                    'status' => 'accepted',
                    'order' => 'status',
                    'direction' => 'desc',
                ])
            );

        $zones = new Membership($mock);
        $result = $zones->listMemberships('Demo Account', 'accepted', 1, 20, 'status', 'desc');

        $this->assertTrue(property_exists($result, "result"));
        // $this->assertObjectHasAttribute('result', $result);
        // $this->assertObjectHasAttribute('result_info', $result);
        $this->assertTrue(property_exists($result, "result_info"));

        $this->assertEquals('4536bcfad5faccb111b47003c79917fa', $result->result[0]->id);
        $this->assertEquals(1, $result->result_info->page);
        $this->assertEquals('4536bcfad5faccb111b47003c79917fa', $zones->getBody()->result[0]->id);
    }

    public function testGetMembershipDetails()
    {
        $response = $this->getPsr7JsonResponseForFixture('Endpoints/getMembershipDetails.json');

        $mock = $this->createMock(Adapter::class);
        $mock->method('get')->willReturn($response);

        $membership = new Membership($mock);
        $details = $membership->getMembershipDetails('4536bcfad5faccb111b47003c79917fa');

        $this->assertTrue(property_exists($details, "id"));
        // $this->assertObjectHasAttribute('id', $details);
        $this->assertEquals('4536bcfad5faccb111b47003c79917fa', $details->id);
        $this->assertTrue(property_exists($details, "code"));
        // $this->assertObjectHasAttribute('code', $details);
        $this->assertEquals('05dd05cce12bbed97c0d87cd78e89bc2fd41a6cee72f27f6fc84af2e45c0fac0', $details->code);
        $this->assertEquals('4536bcfad5faccb111b47003c79917fa', $membership->getBody()->result->id);
    }

    public function testUpdateMembershipDetails()
    {
        $response = $this->getPsr7JsonResponseForFixture('Endpoints/updateMembershipStatus.json');

        $mock = $this->createMock(Adapter::class);
        $mock->method('put')->willReturn($response);

        $mock->expects($this->once())
            ->method('put')
            ->with(
                $this->equalTo('memberships/4536bcfad5faccb111b47003c79917fa'),
                $this->equalTo([
                    'status' => 'accepted'
                ])
            );

        $membership = new Membership($mock);
        $membership->updateMembershipStatus('4536bcfad5faccb111b47003c79917fa', 'accepted');
        $this->assertEquals('4536bcfad5faccb111b47003c79917fa', $membership->getBody()->result->id);
    }

    public function testDeleteMembership()
    {
        $response = $this->getPsr7JsonResponseForFixture('Endpoints/deleteMembership.json');

        $mock = $this->createMock(Adapter::class);
        $mock->method('delete')->willReturn($response);

        $mock->expects($this->once())
            ->method('delete')
            ->with($this->equalTo('memberships/4536bcfad5faccb111b47003c79917fa'));

        $membership = new Membership($mock);

        $membership->deleteMembership('4536bcfad5faccb111b47003c79917fa');

        $this->assertEquals('4536bcfad5faccb111b47003c79917fa', $membership->getBody()->result->id);
    }
}
